#include "StdV3D.h"
#include <limits>
#include "BlobBase.h"



namespace V3D {


BlobBase::BlobBase(float fCenterEnergy, BlobBase::EEvalType etStyle /*= BlobBase::etPolynom4 */ )
:   m_etEvaluation(etStyle),
    m_fFullEnergy( fCenterEnergy)
{}



void BlobBase::SetCenterEnergy(float fEnergy)
{
	m_fFullEnergy = fEnergy;
}

void BlobBase::SetStyle(EEvalType etStyle)
{
	m_etEvaluation = EEvalType( int32(etStyle) % int32(BlobBase::etLast) );
}


bool BlobBase::GetBlobBounds(BoundAabb& blobBounds) const
{
	blobBounds = m_boundAABB;
	return m_bBounded;
}


bool BlobBase::GetBlobBounds(Vector3D&  vcBlobMin, Vector3D& vcBlobMax) const
{
	vcBlobMin = m_boundAABB.GetMin();
	vcBlobMax = m_boundAABB.GetMax();
	return m_bBounded;
}

void BlobBase::NotifyBoundsChange()
{
	Vector3D vcMin, vcMax;
	m_bBounded = ComputeBlobBounds(vcMin, vcMax);

	if( ! m_bBounded )
	{
		static const LengthType k_rMinVal = std::numeric_limits<LengthType>::min();
		static const LengthType k_rMaxVal = std::numeric_limits<LengthType>::max();

		vcMin.Set( k_rMinVal, k_rMinVal, k_rMinVal);	
		vcMax.Set( k_rMaxVal, k_rMaxVal, k_rMaxVal);	
	}
	m_boundAABB.SetMinMax(vcMin, vcMax);
}


bool BlobBase::ComputeBlobBounds(Vector3D& /* vcBlobMin */, Vector3D& /* vcBlobMax */) const
{
	return false;
}


// Calcule a partir de la boite definie par vcBoxMin et vcBoxMax, son sous-ensemble minimum contenant le blob
// Retourne true si cette boite minimum existe (volume non nul)

bool BlobBase::ComputeMinEnclosingBoxAligned(Vector3D& vcMin, Vector3D& vcMax, const Vector3D& vcBoxMin, const Vector3D& vcBoxMax) const
{
	// Pour la class BlobBase, on ne connait rien de plus que la boite englobante alignee sur les axes, 
	// La boite minimum est l'intersection de cette boite englobante avec la boite fournie en parametres.

	BoundAabb boundsIntersection = GetBlobBounds();
	boundsIntersection.Intersection(vcBoxMin, vcBoxMax);
	vcMin = boundsIntersection.GetMin();
	vcMax = boundsIntersection.GetMax();
	return m_boundAABB.Intersects(vcBoxMin, vcBoxMax);;
}


void BlobBase::FindInfluencedVertices( VertexIndexArray& anVtxInfluencedIdx, const Vect3DArray& aPos) const
{
	int32 nVertexCount = aPos.size();
	FindInfluencedVerticesSubArray( anVtxInfluencedIdx, aPos, 0, nVertexCount);
}


void BlobBase::FindInfluencedVerticesSubArray( VertexIndexArray& anVtxInfluencedIdx, const Vect3DArray& aPos,
                                                int32 nStart, int32 nCount) const
{
	anVtxInfluencedIdx.resize(0);
	int32 nEnd = nStart + nCount;

	// On ne mettra fEnergy a 0 que quand sa valeur a change
	float fEnergy = 0.f;
	for(int32 i = nStart; i < nEnd; ++i)
	{
		const Vector3D& pos = aPos[i];
		
		bool bEnergyNotZero = EnergyAddAtPos( fEnergy, pos );

		if( bEnergyNotZero )
			anVtxInfluencedIdx.push_back(i);
	}
}



} // namespace

